/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.service.managedsystem.fru.config;

import com.ibm.hwmca.fw.service.config.ClassData;
import com.ibm.hwmca.fw.service.config.XMLMapParser;
import com.ibm.hwmca.fw.service.managedsystem.fru.config.EnclosureConfigEntry;
import com.ibm.hwmca.fw.service.managedsystem.fru.config.EnclosureConfigParser;
import com.ibm.hwmca.fw.util.CommonXMLParser;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.XMLParsingException;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class FruConfigParser
extends XMLMapParser {
    public static final String FEATURE_CODE = "FEATURE_CODE";
    private static final String TRACE_MASKT = "XRVFRUPT";
    private static final String TRACE_MASKF = "XRVFRUPF";
    private static final String TRACE_MASKD = "XRVFRUPD";
    private static final String TAG_FRU_CONFIG = "fru-config";
    private static final String TAG_DESCRIPTIONS = "descriptions";
    private static final String TAG_ENCLOSURES = "enclosures";
    private static final String TAG_ENCLOSURE = "enclosure";
    private static final String TAG_DESC = "desc";
    private static final String TAG_FILE = "file";
    private static final String TAG_CLASS = "class";
    private static final String TAG_PROPERTIES = "properties";
    private static final String ATTRIB_TYPE = "type";
    private static final String ATTRIB_MODEL = "model";
    private Map enclosureConfigMap = null;
    private Map enclosureFileNameMap = null;
    private String descPropertiesFile = null;
    private String type = "";
    private String model = "";

    public static void main(String[] args) {
        try {
            FruConfigParser p = new FruConfigParser();
            Map m = p.parseXML(new File(System.getProperty("CONSOLE_PATH") + "/" + args[0]));
            System.out.println("map=" + m);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public FruConfigParser() throws SAXNotRecognizedException, SAXNotSupportedException {
        this.setFeature("http://xml.org/sax/features/validation", true);
        this.setErrorHandler(this);
    }

    public Map parseXML(String xmlFile) throws XMLParsingException {
        return this.parseXML(new File(xmlFile));
    }

    public Map parseXML(File file) throws XMLParsingException {
        Trace.trace(TRACE_MASKT, "FruConfigParser parsing file: " + file);
        try {
            this.parse(new InputSource(new FileInputStream(file)));
            Document doc = this.getDocument();
            NodeList nodeList = doc.getElementsByTagName(TAG_DESCRIPTIONS);
            if (nodeList != null && nodeList.getLength() > 0) {
                Trace.trace(TRACE_MASKF, "FruConfigParser.parseXML: parsing descriptions properties filename");
                this.descPropertiesFile = FruConfigParser.parseDescriptionsPropertiesFileName(nodeList.item(0));
                Trace.trace(TRACE_MASKF, "FruConfigParser.parseXML: parsing descriptions properties filename: " + this.descPropertiesFile);
            }
            if ((nodeList = doc.getElementsByTagName(TAG_ENCLOSURES)) != null) {
                Trace.trace(TRACE_MASKF, "FruConfigParser.parseXML: parsing enclosure defs");
                this.enclosureConfigMap = this.parseEnclosures(nodeList.item(0));
                Trace.trace(TRACE_MASKF, "FruConfigParser.parseXML: enclosure defs parsed: " + this.enclosureConfigMap);
            }
        }
        catch (Exception thrown) {
            Trace.trace(TRACE_MASKT, "<-! FruConfigParser.parseXML exception caught: " + thrown);
            Trace.trace(TRACE_MASKT, thrown);
            if (thrown instanceof XMLParsingException) {
                throw (XMLParsingException)thrown;
            }
            throw new XMLParsingException(thrown);
        }
        Trace.trace(TRACE_MASKT, "<- FruConfigParser parsing file: " + file);
        return this.enclosureConfigMap;
    }

    private Map parseEnclosures(Node nodeToParse) throws XMLParsingException {
        HashMap<String, EnclosureConfigEntry> enclosuresMap = new HashMap<String, EnclosureConfigEntry>();
        NodeList nodes = nodeToParse.getChildNodes();
        int aii = 0;
        while (aii < nodes.getLength()) {
            Node node = nodes.item(aii);
            if (node.getNodeType() == 1 && node.getNodeName().toLowerCase().equals(TAG_ENCLOSURE)) {
                this.type = node.getAttributes().getNamedItem(ATTRIB_TYPE).getNodeValue().toUpperCase();
                this.model = node.getAttributes().getNamedItem(ATTRIB_MODEL) != null ? node.getAttributes().getNamedItem(ATTRIB_MODEL).getNodeValue().toUpperCase() : FEATURE_CODE;
                EnclosureConfigEntry ece = this.parseEnclosure(node);
                ece.setType(this.type);
                ece.setModel(this.model);
                enclosuresMap.put(this.type + "|" + this.model, ece);
                Trace.trace(TRACE_MASKF, "FruConfigParser.parseEnclosures: addding type|model enclosure key:" + this.type + "|" + this.model);
            }
            ++aii;
        }
        return enclosuresMap;
    }

    private EnclosureConfigEntry parseEnclosure(Node nodeToParse) throws XMLParsingException {
        Trace.trace(TRACE_MASKT, "-> FruConfigParser.parseLocations");
        Map locationsMap = new HashMap();
        NodeList nodes = nodeToParse.getChildNodes();
        EnclosureConfigEntry ece = new EnclosureConfigEntry();
        ClassData classData = null;
        Map props = null;
        try {
            int aii = 0;
            while (aii < nodes.getLength()) {
                Node node = nodes.item(aii);
                if (node.getNodeType() == 1) {
                    String tag = node.getNodeName().toLowerCase();
                    if (tag.equals(TAG_FILE)) {
                        String filename = System.getProperty("CONSOLE_PATH") + "/" + CommonXMLParser.gatherTextContents(node).trim();
                        if (this.enclosureFileNameMap == null) {
                            this.enclosureFileNameMap = new HashMap();
                        }
                        if (this.enclosureFileNameMap.containsKey(filename)) {
                            Trace.trace(TRACE_MASKF, "FruConfigParser.parseLocations: reusing previously parsed enclosure config for filename: " + filename);
                            locationsMap = (Map)this.enclosureFileNameMap.get(filename);
                        } else {
                            Trace.trace(TRACE_MASKF, "FruConfigParser.parseLocations: parsing enclosure config filename: " + filename);
                            locationsMap = new EnclosureConfigParser().parseXML(filename);
                            Trace.trace(TRACE_MASKD, "FruConfigParser.parseLocations: parsed enclosure map: " + locationsMap);
                            this.enclosureFileNameMap.put(filename, locationsMap);
                        }
                        ece.setLocations(locationsMap);
                    } else if (tag.equals(TAG_DESC)) {
                        ece.setDesc(new LocalizableText(this.descPropertiesFile, CommonXMLParser.gatherTextContents(node)));
                    } else if (tag.equals(TAG_CLASS)) {
                        classData = new ClassData();
                        classData.setClassName(CommonXMLParser.gatherTextContents(node));
                        ece.setClassData(classData);
                    } else if (tag.equals(TAG_PROPERTIES)) {
                        props = ClassData.parseInputMap(node);
                    }
                }
                ++aii;
            }
            if (classData != null && props != null) {
                classData.setConfigData(props);
            }
        }
        catch (Exception e) {
            if (e instanceof XMLParsingException) {
                throw (XMLParsingException)e;
            }
            throw new XMLParsingException(e);
        }
        Trace.trace(TRACE_MASKT, "<- FruConfigParser.parseLocations");
        return ece;
    }

    public static String parseDescriptionsPropertiesFileName(Node node) throws XMLParsingException {
        String retString;
        Trace.trace(TRACE_MASKT, "-> parseDescriptionsPropertiesFileName");
        try {
            retString = CommonXMLParser.gatherTextContents(node);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-! parseDescriptionsPropertiesFileName: exception caught:  " + e);
            Trace.trace(TRACE_MASKT, e);
            throw new XMLParsingException("exception caught resolving descriptions filename");
        }
        Trace.trace(TRACE_MASKT, "<- parseDescriptionsPropertiesFileName, returning " + retString);
        return retString;
    }
}

